@REM *************************************************************
@REM This script configure Mirth Connect Server instance for SQWM 
@REM *************************************************************
@echo off
setlocal

set ENV_ONLY=NO
if [%1] == [envonly] (
   echo Will only update environment-specific deployment configuration.
   SET ENV_ONLY=YES
   SHIFT
)

set ENV_NAME=%1

if [%ENV_NAME%] equ [] (
   @echo.
   @echo Missing an environment name
   @echo.
   @echo Usage: update.cmd [environment]
   @echo where environment is a name of a sub directory containing
   @echo configuration files and scripts to configure a fully 
   @echo functional Mirth Connect Server instance.
   @echo.
   @echo For instance: update.cmd local
   @echo.
   goto end
)

set ENV_DIR=%cd%\env\%ENV_NAME%
set SQWM_XML=%ENV_DIR%\sqwm.xml

if not exist "%ENV_DIR%" (
   @echo.
   @echo Missing "%ENV_DIR%" directory
   @echo.
   goto end
)

if not exist "%SQWM_XML%" (
   @echo.
   @echo Missing %SQWM_XML%!
   @echo.
   goto end
)

REM === Read environment parameters from properties files ===

echo Configuring environment parameters...

REM sys.installationDir
FOR /F "eol=; tokens=2,2 delims==" %%i IN ('findstr /i "sys.installationDir" %ENV_DIR%\server.properties') DO set sys.installationDir=%%i

REM VASQIP_INBOX
FOR /F "eol=; tokens=2 delims==" %%i IN ('findstr /i "vasqipInboxDir" %ENV_DIR%\sqwm.properties') DO set VASQIP_INBOX=%%i
IF ERRORLEVEL 1 EXIT /B 1
REM Strip a leading space
IF "%VASQIP_INBOX:~0,1%"==" " SET VASQIP_INBOX=%VASQIP_INBOX:~1%
REM Replace / with \ in path.
SET VASQIP_INBOX=%VASQIP_INBOX:/=\%

REM BATCH_INBOX
FOR /F "eol=; tokens=2 delims==" %%i IN ('findstr /i "batchInboxDir" %ENV_DIR%\sqwm.properties') DO set BATCH_INBOX=%%i
IF ERRORLEVEL 1 EXIT /B 1
REM Strip a leading space
IF "%BATCH_INBOX:~0,1%"==" " SET BATCH_INBOX=%BATCH_INBOX:~1%
REM Replace / with \ in path.
SET BATCH_INBOX=%BATCH_INBOX:/=\%

REM === Actual Update Process ===

@echo Deploying Mirth Connect Server Configuration for %ENV_NAME% environment
timeout 3 /nobreak >nul

REM Create specific VASQIP directory if it don't exist. Must do this or else the
REM Centricity VASQIP extract process will fail.
IF NOT EXIST "%VASQIP_INBOX%\" (
   mkdir "%VASQIP_INBOX%"
   REM Just quit on failure, mkdir should have printed the error for us.
   IF ERRORLEVEL 1 EXIT /B 1
)

REM As above, create batch inbox directory if it don't exist.
IF NOT EXIST "%BATCH_INBOX%\" (
   mkdir "%BATCH_INBOX%"
   REM Just quit on failure, mkdir should have printed the error for us.
   IF ERRORLEVEL 1 EXIT /B 1
)

REM As above, create tools directory if it don't exist.
SET TOOLS_DIR=%sys.installationDir%\tools
IF NOT EXIST "%TOOLS_DIR%\" (
   mkdir "%TOOLS_DIR%"
   REM Just quit on failure, mkdir should have printed the error for us.
   IF ERRORLEVEL 1 EXIT /B 1
)

@echo Copying Mirth Connect Server JVM Options to %sys.installationDir%
copy %ENV_DIR%\..\common\*.vmoptions "%sys.installationDir%"

@echo Copying SIG Deployment Properties to %sys.installationDir%\conf
copy %ENV_DIR%\sqwm.properties "%sys.installationDir%\conf"
copy %ENV_DIR%\log4j.properties "%sys.installationDir%\conf"

IF NOT %ENV_ONLY% == YES (
      echo Copying tools...
      copy %cd%\tools\* "%TOOLS_DIR%\"
      echo Updating SIG Build...
      @echo importcfg %SQWM_XML% > %ENV_DIR%\deploy.cfg
      "%sys.installationDir%\mccommand.exe" -s %ENV_DIR%\deploy.cfg
)

echo Restarting Mirth Connect.
"%sys.installationDir%\mcservice.exe" -stop
timeout 5 /nobreak >nul
"%sys.installationDir%\mcservice.exe" -start

timeout 15 /nobreak >nul

:end
endlocal
